from datetime import datetime
from pymongo.errors import DuplicateKeyError
from app.db import database
from app.v1.models.platform.workforcetimesheet import WorkforceTimesheet

COLLECTION_NAME = "workforce_timesheet"

def create_timesheet_entry(data: WorkforceTimesheet, db: database.MongoDB) -> dict:
    collection = db[COLLECTION_NAME]
    entry_data = data.dict()
    entry_data["created_date"] = datetime.utcnow()
    entry_data["updated_date"] = datetime.utcnow()

    result = collection.insert_one(entry_data)
    entry_data["_id"] = str(result.inserted_id)
    return entry_data

def get_timesheet_entries(account_id: str, db: database.MongoDB) -> list:
    collection = db[COLLECTION_NAME]
    records = list(collection.find({"account_id": account_id}))
    for r in records:
        r["_id"] = str(r["_id"])
    return records
